<?php
/**
* @package		Komento
* @copyright	Copyright (C) 2012 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Komento is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');
?>
<table class="noshow">
	<tr>
		<td valign="top" width="50%">
			<fieldset class="adminform">
			<legend><?php echo JText::_( 'COM_KOMENTO_SETTINGS_WORKFLOW_GENERAL' ); ?></legend>
			<table class="admintable" cellspacing="1">
				<tbody>

					<!-- Enable Comments on this Component -->
					<?php echo $this->renderSetting( 'COM_KOMENTO_SETTINGS_ENABLE_SYSTEM', 'enable_komento' ); ?>

					<!-- Disable Komento on tmpl=component -->
					<?php echo $this->renderSetting( 'COM_KOMENTO_SETTINGS_DISABLE_ON_TMPL_COMPONENT', 'disable_komento_on_tmpl_component' ); ?>

				</tbody>
			</table>
			</fieldset>

			<?php if( method_exists( $this->componentObj , 'getCategories' ) ) { ?>
			<fieldset class="adminform">
			<legend><?php echo JText::_( 'COM_KOMENTO_SETTINGS_CATEGORIES' ); ?></legend>
			<p class="small"><?php echo JText::_( 'COM_KOMENTO_SETTINGS_CATEGORIES_INFO' ); ?></p>
			<table class="admintable" cellspacing="1">
				<tbody>

					<!-- Categories Assignment -->
					<?php $options = array();
						$options[] = array( '0', 'COM_KOMENTO_SETTINGS_CATEGORIES_ON_ALL_CATEGORIES' );
						$options[] = array( '1', 'COM_KOMENTO_SETTINGS_CATEGORIES_ON_SELECTED_CATEGORIES' );
						$options[] = array( '2', 'COM_KOMENTO_SETTINGS_CATEGORIES_ON_ALL_CATEGORIES_EXCEPT_SELECTED' );
						$options[] = array( '3', 'COM_KOMENTO_SETTINGS_CATEGORIES_NO_CATEGORIES' );
						echo $this->renderSetting( 'COM_KOMENTO_SETTINGS_CATEGORIES_ASSIGNMENT', 'allowed_categories_mode', 'dropdown', $options );
					?>

					<!-- Enable Comments on this Categories -->
					<?php $categories = $this->componentObj->getCategories();
						echo $this->renderSetting( 'COM_KOMENTO_SETTINGS_ENABLE_ON_CATEGORIES', 'allowed_categories', 'multilist', $categories );
					?>
				</tbody>
			</table>
			</fieldset>
			<?php } ?>

			<fieldset class="adminform">
			<legend><?php echo JText::_( 'COM_KOMENTO_SETTINGS_SYSTEM' ); ?></legend>
			<table class="admintable" cellspacing="1">
				<tbody>

					<!-- Convert Orphanitem -->
					<?php echo $this->renderSetting( 'COM_KOMENTO_SETTINGS_ENABLE_ORPHANITEM_CONVERT', 'enable_orphanitem_convert' ); ?>

					<!-- Orphanitem Ownership -->
					<?php echo $this->renderSetting( 'COM_KOMENTO_SETTINGS_ORPHANITEM_OWNERSHIP', 'orphanitem_ownership', 'input' ); ?>

				</tbody>
			</table>
			</fieldset>
		</td>
		<td valign="top" width="50%">
			<fieldset class="adminform">
			<legend><?php echo JText::_( 'COM_KOMENTO_SETTINGS_MODERATION' ); ?></legend>
			<p class="small"><?php echo JText::_( 'COM_KOMENTO_SETTINGS_MODERATION_INFO' ); ?></p>
			<table class="admintable" cellspacing="1">
				<tbody>

					<!-- Requires Moderation -->
					<?php $usergroups = Komento::getUsergroups();
						foreach( $usergroups as &$usergroup )
						{
							$usergroup->treename = str_repeat( '.&#160;&#160;&#160;', $usergroup->depth ) . ( $usergroup->depth > 0 ? '|_&#160;' : '' ) . $usergroup->title;
						}
						echo $this->renderSetting( 'COM_KOMENTO_SETTINGS_MODERATION_USERGROUP', 'requires_moderation', 'multilist', $usergroups );
					?>
				</tbody>
			</table>
			</fieldset>

			<fieldset class="adminform">
			<legend><?php echo JText::_( 'COM_KOMENTO_SETTINGS_SUBSCRIPTION' ); ?></legend>
			<table class="admintable" cellspacing="1">
				<tbody>

					<!-- Enforce subscription -->
					<?php echo $this->renderSetting( 'COM_KOMENTO_SETTINGS_SUBSCRIPTION_AUTO', 'subscription_auto' ); ?>

					<!-- Requires confirmation -->
					<?php echo $this->renderSetting( 'COM_KOMENTO_SETTINGS_SUBSCRIPTION_CONFIRMATION', 'subscription_confirmation' ); ?>

				</tbody>
			</table>
			</fieldset>

			<fieldset class="adminform">
			<legend><?php echo JText::_( 'COM_KOMENTO_SETTINGS_RSS' ); ?></legend>
			<table class="admintable" cellspacing="1">
				<tbody>

					<!-- Enable RSS -->
					<?php echo $this->renderSetting( 'COM_KOMENTO_SETTINGS_RSS_ENABLE', 'enable_rss' ); ?>

					<!-- Max RSS Items -->
					<?php echo $this->renderSetting( 'COM_KOMENTO_SETTINGS_RSS_MAX_ITEMS', 'rss_max_items', 'input' ); ?>

				</tbody>
			</table>
			</fieldset>
		</td>
	</tr>
</table>
