<?php
/*
CityLife template for Joomla!
Commercial Software
Copyright 2013 joomlaxtc.com
All Rights Reserved
www.joomlaxtc.com
*/
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers');

// Create shortcuts to some parameters.
$params		= $this->item->params;
$images = json_decode($this->item->images);
$urls = json_decode($this->item->urls);
$canEdit	= $this->item->params->get('access-edit');
$user		= JFactory::getUser();

$hasHeading = 
($params->get('show_author') && !empty($this->item->author )) ||
($params->get('show_parent_category') && $this->item->parent_slug != '1:root') ||
($params->get('show_category')) ||
($params->get('show_create_date')) ||
($params->get('show_modify_date')) ||
($params->get('show_publish_date')) ||
($params->get('show_hits')) ||
(isset($urls) AND ((!empty($urls->urls_position) AND ($urls->urls_position=='0')) OR  ($params->get('urls_position')=='0' AND empty($urls->urls_position) )) OR (empty($urls->urls_position) AND (!$params->get('urls_position'))) );

$mainwidth = $hasHeading ? 'span9' : 'span12';

?>
<div class="item-page<?php echo $this->pageclass_sfx?>">
	<?php
		if ($this->params->get('show_page_heading')) {
			?><h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1><?php
		}
		
		if ($params->get('access-view')) {
			if (isset($images->image_fulltext) and !empty($images->image_fulltext)) {
				$imgfloat = (empty($images->float_fulltext)) ? $params->get('float_fulltext') : $images->float_fulltext;
				$caption = ($images->image_fulltext_caption) ? 'class="caption" title="'.htmlspecialchars($images->image_fulltext_caption).'"' : '';
				?>
					<div class="img-fulltext-<?php echo htmlspecialchars($imgfloat); ?>">
						<img <?php echo $caption; ?> src="<?php echo htmlspecialchars($images->image_fulltext); ?>" alt="<?php echo htmlspecialchars($images->image_fulltext_alt); ?>" />
					</div>
				<?php
			}

			?>
				
					<?php if ($params->get('show_title')) { ?>
                    <div class="article_heading">
						<h2 class="title">
						<?php if ($params->get('link_titles') && !empty($this->item->readmore_link)) { ?>
							<a href="<?php echo $this->item->readmore_link; ?>">
							<?php echo $this->escape($this->item->title); ?></a>
						<?php } else { ?>
							<?php echo $this->escape($this->item->title); ?>
						<?php } ?>
						</h2>
				
	</div>
                	<?php } ?>
                    <?php if ($params->get('show_tags', 1) && !empty($this->item->tags)) : ?>
		<?php $this->item->tagLayout = new JLayoutFile('joomla.content.tags'); ?>

		<?php echo $this->item->tagLayout->render($this->item->tags->itemTags); ?>
	<?php endif; ?>
	  		  <?php if ($canEdit ||  $params->get('show_print_icon') || $params->get('show_email_icon')) : ?>
	<div class="actions">
	<?php if (!$this->print) : ?>
		<?php if ($params->get('show_print_icon')) : ?>
			
			<?php echo JHtml::_('icon.print_popup',  $this->item, $params); ?>
			
		<?php endif; ?>

		<?php if ($params->get('show_email_icon')) : ?>
		
			<?php echo JHtml::_('icon.email',  $this->item, $params); ?>
			
		<?php endif; ?>

		<?php if ($canEdit) : ?>
			
			<?php echo JHtml::_('icon.edit', $this->item, $params); ?>
			
		<?php endif; ?>

	<?php else : ?>
	
		<?php echo JHtml::_('icon.print_screen',  $this->item, $params); ?>
		
	<?php endif; ?>

	</div>
<?php endif; ?>

				
			<?php

			if (!$params->get('show_intro')) {
				echo $this->item->event->afterDisplayTitle;
			}
			echo $this->item->event->beforeDisplayContent;

			?>
				<div class="row-fluid">

					
					
					<div class="<?php echo $mainwidth; ?> maincontent">
						<?php 
							echo $this->item->text;
						?>
					</div>
                    
                    <?php if ($hasHeading) { ?>
	     			<div class="span3 artinfo">
							<?php
								if (isset($urls) AND ((!empty($urls->urls_position) AND ($urls->urls_position=='0')) OR  ($params->get('urls_position')=='0' AND empty($urls->urls_position) )) OR (empty($urls->urls_position) AND (!$params->get('urls_position')))) {
									echo $this->loadTemplate('links');
								}
							?>

							<?php if ($params->get('show_author') && !empty($this->item->author )) { ?>
								<div class="createdby">
									<?php
										$author = $this->item->created_by_alias ? $this->item->created_by_alias : $this->item->author;
										if (!empty($this->item->contactid) && $params->get('link_author') == true) {
											$needle = 'index.php?option=com_contact&view=contact&id=' . $this->item->contactid;
											$menu = JFactory::getApplication()->getMenu();
											$item = $menu->getItems('link', $needle, true);
											$cntlink = !empty($item) ? $needle . '&Itemid=' . $item->id : $needle;
											echo JText::sprintf('COM_CONTENT_WRITTEN_BY', JHtml::_('link', JRoute::_($cntlink), $author));
										} else {
											echo JText::sprintf('COM_CONTENT_WRITTEN_BY', $author);
										}
									?>
								</div>
							<?php } ?>
	
							<?php if ($params->get('show_parent_category') && $this->item->parent_slug != '1:root') { ?>
								<div class="parent-category-name">
									<?php
										$title = $this->escape($this->item->parent_title);
										$url = '<a href="'.JRoute::_(ContentHelperRoute::getCategoryRoute($this->item->parent_slug)).'">'.$title.'</a>';
										if ($params->get('link_parent_category') and $this->item->parent_slug) {
											echo JText::sprintf('COM_CONTENT_PARENT', $url);
										} else {
											echo JText::sprintf('COM_CONTENT_PARENT', $title);
										}
									?>
								</div>
							<?php } ?>
	
							<?php if ($params->get('show_category')) { ?>
								<div class="category-name">
									<?php
										$title = $this->escape($this->item->category_title);
										$url = '<a href="'.JRoute::_(ContentHelperRoute::getCategoryRoute($this->item->catslug)).'">'.$title.'</a>';
										if ($params->get('link_category') and $this->item->catslug) {
											echo JText::sprintf('COM_CONTENT_CATEGORY', $url);
										} else {
											echo JText::sprintf('COM_CONTENT_CATEGORY', $title);
										}
									?>
								</div>
							<?php } ?>
	
							<?php if ($params->get('show_create_date')) { ?>
								<div class="create">
									<?php echo JText::sprintf('COM_CONTENT_CREATED_DATE_ON', JHtml::_('date', $this->item->created, JText::_('DATE_FORMAT_LC2'))); ?>
								</div>
							<?php } ?>
	
							<?php if ($params->get('show_modify_date')) { ?>
								<div class="modified">
									<?php echo JText::sprintf('COM_CONTENT_LAST_UPDATED', JHtml::_('date', $this->item->modified, JText::_('DATE_FORMAT_LC2'))); ?>
								</div>
							<?php } ?>
	
							<?php if ($params->get('show_publish_date')) { ?>
								<div class="published">
									<?php echo JText::sprintf('COM_CONTENT_PUBLISHED_DATE_ON', JHtml::_('date', $this->item->publish_up, JText::_('DATE_FORMAT_LC2'))); ?>
								</div>
							<?php } ?>
						
							<?php if ($params->get('show_hits')) { ?>
								<div class="hits">
									<?php echo JText::sprintf('COM_CONTENT_ARTICLE_HITS', $this->item->hits); ?>
								</div>
							<?php } ?>
	
							<?php if (isset ($this->item->toc)) { ?>
								<?php echo $this->item->toc; ?>
							<?php } ?>
		
							<?php
								if (isset($urls) AND ((!empty($urls->urls_position)  AND ($urls->urls_position=='1')) OR ( $params->get('urls_position')=='1') )) {
									echo $this->loadTemplate('links');
								}
							?>
						</div>
					<?php } ?>
                    
				</div>
                
                
			<?php

			if (!empty($this->item->pagination) AND $this->item->pagination AND $this->item->paginationposition AND!$this->item->paginationrelative) {
				echo $this->item->pagination;
			}
				
		} elseif ($params->get('show_noauth') == true and  $user->get('guest') )  {
			echo $this->item->introtext;
			//Optional link to let them register to see the whole article.
			if ($params->get('show_readmore') && $this->item->fulltext != null) {
				$link1 = JRoute::_('index.php?option=com_users&view=login');
				$link = new JURI($link1);
				?>
					<p class="readmore">
						<a href="<?php echo $link; ?>">
							<?php
								$attribs = json_decode($this->item->attribs);
								if ($attribs->alternative_readmore == null) {
									echo JText::_('COM_CONTENT_REGISTER_TO_READ_MORE');
								} elseif ($readmore = $this->item->alternative_readmore) {
									echo $readmore;
									if ($params->get('show_readmore_title', 0) != 0) {
										echo JHtml::_('string.truncate', ($this->item->title), $params->get('readmore_limit'));
									}
								} elseif ($params->get('show_readmore_title', 0) == 0) {
									echo JText::sprintf('COM_CONTENT_READ_MORE_TITLE');
								} else {
									echo JText::_('COM_CONTENT_READ_MORE');
									echo JHtml::_('string.truncate', ($this->item->title), $params->get('readmore_limit'));
								}
							?>
						</a>
					</p>
				<?php
			}
		}
					
		echo $this->item->event->afterDisplayContent;

		if (!empty($this->item->pagination) AND $this->item->pagination AND $this->item->paginationposition AND $this->item->paginationrelative) {
		 echo $this->item->pagination;
		}
	?>
</div>
