<?php
/*
CityLife template for Joomla!
Commercial Software
Copyright 2013 joomlaxtc.com
All Rights Reserved
www.joomlaxtc.com
*/
defined( '_JEXEC' ) or die;

JHtml::_('behavior.framework');$document =JFactory::getDocument();
$app = JFactory::getApplication();
$menu = $app->getMenu()->getActive();

$pageclass = $menu->params->get('pageclass_sfx');
$pageview = xtcIsFrontpage() ? 'frontpage' : 'innerpage';
$user =JFactory::getUser();
$params = $templateParameters->group->$layout; // We got $layout from the index.php
// Use the Grid parameters to compute the main columns width
$grid = $params->xtcgrid;
$style = $params->xtcstyle;
$typo = $params->xtctypo;
$css3 = $params->xtccss3;

//Group parameters from grid.xml
$gridParams = $templateParameters->group->$grid;
$styleParams = $templateParameters->group->$style;
$typoParams = $templateParameters->group->$typo;
$tmplWidth = 100;
// Start of HEAD
JHtml::_('stylesheet', 'jui/bootstrap.min.css', array(), true);
if ($templateParameters->group->grid->responsive) { JHtml::_('stylesheet', 'jui/bootstrap-responsive.min.css', array(), true); }
JHtml::_('stylesheet', 'jui/bootstrap-extended.css', array(), true);
if ($typoParams->direction === 'rtl') { JHtml::_('stylesheet', 'jui/bootstrap-rtl.css', array(), true); }

JHtml::_('bootstrap.framework');
if ($templateParameters->jquery) { JHtml::_('jquery.framework',true); }?>
<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>">
<head>
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<link rel="stylesheet" href="<?php echo $xtc->templateUrl; ?>css/bootstrap.min.css" type="text/css" />
<?php
// Include the CSS files using the groups as defined in the layout parameters
echo xtcCSS($params->xtctypo,$params->xtcgrid,$params->xtcstyle, $params->xtccss3);
// Get Xtc Menu library
$document->addScript($xtc->templateUrl.'js/xtcMenu.js'); 
$document->addScriptDeclaration("window.addEvent('load', function(){ xtcMenu(null, 'menu', 150, 50, 'h', new Fx.Transition(Fx.Transitions.Cubic.easeInOut), 90, true, false); });");
// Get the Parallax Scripts
if (!$xtc->agent->isMobile && $styleParams->parallax && xtcIsFrontpage()) {
	$document->addScript($xtc->templateUrl.'js/xtcScripts.js');
	$document->addScript($xtc->templateUrl.'js/jquery.scrollorama.js');
}
//Get the Smooth Scroll Effect
if ($styleParams->smoothscroll) { 
	$document->addScript($xtc->templateUrl.'js/jquery.smooth-scroll.min.js');
	$document->addScriptDeclaration("window.addEvent('domready',function() {
		jQuery('a').smoothScroll({speed:700});
	 });");
}
?>
<!--[if lt IE 10]>
<style media="screen" type="text/css">
body
 {opacity:1!important;} 
</style>
<![endif]-->
<jdoc:include type="head" />
</head>
<?php
// End of HEAD
// Start of BODY
$stickyClass = $gridParams->stickyheader;
?>
<body id="bttop" class="<?php echo $pageview;?> <?php echo $stickyClass;?> <?php echo $pageclass ? htmlspecialchars($pageclass) : 'default'; ?>">
	<div id="headerwrap" class="xtc-bodygutter <?php echo $stickyClass;?>">
		<div id="header" class="xtc-wrapper clearfix">
			<div id="logo" class="hd2">
				<a class="hideTxt" href="index.php">
					<?php echo $app->getCfg('sitename');?>
				</a>
			</div>
			<?php if ($this->countModules('menuright2') || $this->countModules('menuright1')) : ?>
				<div id="menu2" class="hd2">
					<?php if ($this->countModules('menuright2')) : ?>
						<div id="menuright2">                           
							<jdoc:include type="modules" name="menuright2" style="xtc"/>
						</div>
					<?php endif; ?> 
					<?php if ($this->countModules('menuright1')) : ?>
						<div id="menuright1">                           
							<jdoc:include type="modules" name="menuright1" style="xtc"/>
						</div>
					<?php endif; ?> 
				</div>
			<?php endif; ?> 
			<div id="menuwrap">
				<div id="menu" class="clearfix hd8 <?php echo $gridParams->menustyle;?>">
					<jdoc:include type="modules" name="menubarleft" style="raw" />
				</div>
			</div>
		</div> 
	</div>
	<?php
		// Draw the regions in the specified order
		$regioncfg = $gridParams->regioncfg;
		foreach (explode(",",$regioncfg) as $region) {
			settype($region,'integer');
			$regionfile = __DIR__.'/layout_includes/region'.$region.'.php';
			if (file_exists($regionfile)) { require $regionfile; }
		}
		
		// Build footer grid
		$areaWidth = $tmplWidth;
		$gutter = 0;	
		$order = 'footer,legals';
		$columnArray = array();
		$columnArray['footer'] = '<jdoc:include type="modules" name="footer" style="xtc" />';
		$columnArray['legals'] = '<jdoc:include type="modules" name="legals" style="xtc" />';
		$customWidths = '';
		$columnClass = '';
		$columnPadding = '';
		$debug = '';
		$footer_legals = xtcBootstrapGrid($columnArray,$order,'',$columnClass);
		if ($footer_legals) {
			?>
				<div id="footerwrap" class="xtc-bodygutter">
					<div id="footerwrappad" class="xtc-wrapperpad">
						<div id="footerpad" class="row-fluid xtc-wrapper"><?php echo $footer_legals; ?></div>
					</div>
				</div>
			<?php
		}
	?>
	<jdoc:include type="modules" name="debug" />
</body>
</html>
